<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");
// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve the input data from the JSON body
$data = json_decode(file_get_contents('php://input'), true);

$testimonial_id = $data['testimonial_id'] ?? null;
$seo_title = $data['Seo_title'] ?? null;
$seo_description = $data['Seo_description'] ?? null;
$delete_status = $data['Delete_status'] ?? 0; // Default Delete_status as 0

// Validate required fields
if (!$testimonial_id || !$seo_title || !$seo_description) {
    echo json_encode(["status" => "error", "message" => "testimonial ID, SEO Title, and SEO Description are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$testimonial_id = mysqli_real_escape_string($conn, $testimonial_id);
$seo_title = mysqli_real_escape_string($conn, $seo_title);
$seo_description = mysqli_real_escape_string($conn, $seo_description);
$delete_status = intval($delete_status);

// Insert query
$query = "INSERT INTO testimonial_seo (Testimonial_id, Seo_title, Seo_description, Delete_status) 
          VALUES ('$testimonial_id', '$seo_title', '$seo_description', '$delete_status')";

// Execute the query
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "SEO data for testimonial inserted successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert SEO data for testimonial"]);
}

?>
